# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 7
# Experiment: PMxPM, Run: 5
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A_MR7_strategy.txt
# LLM Suggested Fallback: D

def harmonious_mirage(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not my_history:
        return "C"
    
    current_round = len(my_history) + 1
    
    # Early game: build trust
    if current_round <= 2:
        return "C"
    
    # Mid-game: dynamic response
    if 3 <= current_round <= 7:
        coop_rate = opp_history.count("C") / len(opp_history) if opp_history else 1.0
        if coop_rate >= 0.5:
            # Introduce small randomness to avoid appearing static
            if random.random() < 0.1:
                return "D"
            return "C"
        else:
            return "D"
    
    # Late game: exploit or reciprocate
    if current_round >= 8:
        if current_round == 10:
            return "D"
        if opp_history.count("D") > len(opp_history) / 2:
            return "D"
        else:
            return "C"
    
    # Fallback (shouldn't reach here)
    return "C"